#
# Script to find differences between WMO headers of NWPS v1.3 and NWPS v1.2
# Author: Andre van der Westhuysen
# Last Modified: 08/06/2020
# Requires: Python 3.6.3
#
import numpy as np

# Read data
headers_v12 = np.loadtxt('wmo_headers_nwps_v1-2.txt', dtype='str', delimiter="'")
headers_v13 = np.loadtxt('wmo_headers_nwps_v1-3.txt', dtype='str', delimiter="'")

# Extract headers
headers_v12 = headers_v12[:,3]
headers_v13 = headers_v13[:,3]

# Report summary
print('Length of v1.2 headers (all): '+str(len(headers_v12)))
print('Length of v1.2 headers (unique): '+str(len(set(headers_v12))))
print('Length of v1.3 headers (all): '+str(len(headers_v13)))
print('Length of v1.3 headers (unique): '+str(len(set(headers_v13))))

# Find items removed from v1.2 unique list
removed_items=list(set(headers_v12) - set(headers_v13))
removed_items.sort()
# Find items added in v1.3 unique list
added_items=list(set(headers_v13) - set(headers_v12))
added_items.sort()

# Report results
print('Length of removed items: '+str(len(removed_items)))
print('Length of added items: '+str(len(added_items)))

print('Removed items (first 10):')
print(removed_items[0:9])
print('Added items (first 10):')
print(added_items[0:9])

np.savetxt("nwps_v1-3_removed_header_items.csv", removed_items, fmt='%s', delimiter="'")
np.savetxt("nwps_v1-3_added_header_items.csv", added_items, fmt='%s', delimiter="'")
